LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY rom IS
  PORT(addr : IN INTEGER;
       cs   : IN std_logic;
       data : OUT INTEGER);
END rom;

ARCHITECTURE rom OF rom IS
BEGIN
  PROCESS(addr, cs)
    VARIABLE rom_init : BOOLEAN := FALSE;    -- line 1
    TYPE rom_data_file_t IS FILE OF INTEGER; -- line 2

    FILE rom_data_file : rom_data_file_t IS IN
        "/doug/dlp/test1.dat";                --line 3

    TYPE dtype IS ARRAY(0 TO 63) OF INTEGER;

    VARIABLE rom_data : dtype; -- line 4
    VARIABLE i : INTEGER := 0; -- line 5
  BEGIN
    IF (rom_init = false) THEN   -- line 6
      WHILE NOT ENDFILE(rom_data_file) -- line 7
                AND (i < 64) LOOP
        READ(rom_data_file, rom_data(i)); -- line 8
        i := i + 1;           -- line 9
      END LOOP;
      rom_init := true;       -- line 10
    END IF;
    IF (cs = '1') THEN        -- line 11
      data <= rom_data(addr); -- line 12
    ELSE
      data <= -1;             -- line 13
    END IF;
  END PROCESS;
END rom;

